<?php
if (!defined('ABSPATH')) exit;

class VMDPW_Settings_Page {

    public function __construct() {
        add_action('admin_menu', [$this, 'add_submenu']);
        add_action('admin_init', [$this, 'register_settings']);
    }

    /** إضافة صفحة إعدادات ضمن قائمة الـ CPT */
    public function add_submenu() {

        add_submenu_page(
            'edit.php?post_type=vmdp_project',   // ← تصحيح اسم الـ CPT
            'إعدادات الإضافة',
            'الإعدادات',
            'manage_options',
            'vmdpw-settings',
            [$this, 'render_page']
        );
    }

    /** تسجيل الإعدادات */
    public function register_settings() {

        register_setting(
            'vmdpw_group',
            'vmdpw_settings',
            [
                'sanitize_callback' => [$this, 'sanitize_settings']
            ]
        );

        add_settings_section(
            'vmdpw_section_main',
            'الإعدادات العامة',
            '',
            'vmdpw-settings'
        );

        // الحد الأقصى للصور
        add_settings_field(
            'max_images',
            'الحد الأقصى لعدد الصور',
            [$this, 'field_max_images'],
            'vmdpw-settings',
            'vmdpw_section_main'
        );

        // لون الأزرار
        add_settings_field(
            'button_color',
            'لون أزرار المشروع',
            [$this, 'field_button_color'],
            'vmdpw-settings',
            'vmdpw_section_main'
        );
    }

    /** Sanitization */
    public function sanitize_settings($input) {
        $output = [];

        $output['max_images'] = isset($input['max_images'])
            ? max(1, min(50, intval($input['max_images'])))
            : 10;

        $output['button_color'] = isset($input['button_color'])
            ? sanitize_hex_color($input['button_color'])
            : '#0088ff';

        return $output;
    }

    /** حقل عدد الصور */
    public function field_max_images() {
        $opts = get_option('vmdpw_settings');
        $value = isset($opts['max_images']) ? intval($opts['max_images']) : 10;

        echo "<input type='number' min='1' max='50' name='vmdpw_settings[max_images]' value='{$value}' />";
        echo "<p class='description'>الحد الأعلى لعدد صور التطبيق داخل كل مشروع.</p>";
    }

    /** حقل لون الأزرار */
    public function field_button_color() {
        $opts = get_option('vmdpw_settings');
        $value = isset($opts['button_color']) ? esc_attr($opts['button_color']) : '#0088ff';

        echo "<input type='color' name='vmdpw_settings[button_color]' value='{$value}' />";
        echo "<p class='description'>اللون الافتراضي لأزرار العرض داخل صفحة المشروع.</p>";
    }

    /** صفحة الإعدادات */
    public function render_page() {

        if (!current_user_can('manage_options')) {
            wp_die('غير مسموح لك بالوصول إلى هذه الصفحة.');
        }
        ?>
        <div class="wrap">
            <h1>إعدادات View Mobile Developer Project – Weisro</h1>

            <form method="post" action="options.php">
                <?php
                settings_fields('vmdpw_group');
                do_settings_sections('vmdpw-settings');
                submit_button();
                ?>
            </form>
        </div>
        <?php
    }
}

new VMDPW_Settings_Page();
