jQuery(document).ready(function ($) {

    let media_frame;

    // فتح مكتبة الوسائط
    $(document).on("click", ".weisro-upload-images", function (e) {
        e.preventDefault();

        media_frame = wp.media({
            title: "اختر صور التطبيق",
            library: { type: "image" },
            button: { text: "إضافة الصور" },
            multiple: true
        });

        media_frame.on("select", function () {

            // قراءة الحالي وتنظيفه
            let current = $(".weisro-images-field").val();
            current = current ? current.split(",").filter(v => v.trim() !== "") : [];

            // الصور الجديدة
            let new_imgs = media_frame.state().get("selection").map(
                img => img.toJSON().url
            );

            // دمج ومنع تكرار
            let all = [...current, ...new_imgs].filter((v, i, arr) => arr.indexOf(v) === i);

            $(".weisro-images-field").val(all.join(","));
            renderImagesPreview(all);
        });

        media_frame.open();
    });

    // حذف صورة
    $(document).on("click", ".weisro-remove-img", function () {

        let box = $(this).closest(".weisro-img-box");
        let index = parseInt(box.data("index"));

        let val = $(".weisro-images-field").val();
        let arr = val ? val.split(",").filter(v => v.trim() !== "") : [];

        // حذف حسب الإندكس
        arr.splice(index, 1);

        $(".weisro-images-field").val(arr.join(","));
        renderImagesPreview(arr);
    });

    // رسم المعاينة
    function renderImagesPreview(urls) {

        let preview = $(".weisro-images-preview");
        preview.empty();

        urls.forEach((url, index) => {

            preview.append(`
                <div class="weisro-img-box" data-index="${index}" style="
                    position: relative;
                    display: inline-block;
                    margin: 5px;
                ">
                    <img src="${url}" style="
                        width: 80px;
                        height: 120px;
                        border-radius: 6px;
                        object-fit: cover;
                    ">
                    <span class="weisro-remove-img" style="
                        position: absolute;
                        top: -6px;
                        right: -6px;
                        width: 20px;
                        height: 20px;
                        background: #ff4444;
                        color: #fff;
                        border-radius: 50%;
                        cursor: pointer;
                        font-size: 12px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    ">×</span>
                </div>
            `);
        });
    }

    // إذا في صور محفوظة مسبقاً
    let initVal = $(".weisro-images-field").val();
    if (initVal) {
        let arr = initVal.split(",").filter(v => v.trim() !== "");
        renderImagesPreview(arr);
    }

});
