// assets/script.js
document.addEventListener('DOMContentLoaded', function () {

  // لكل عنصر مشروع على الصفحة
  document.querySelectorAll('.weisro-project-item-wrapper').forEach(wrapper => {
    const thumbsWrap = wrapper.querySelector('.weisro-thumbs');
    const mainImg = wrapper.querySelector('.weisro-main-image');
    const prevBtn = wrapper.querySelector('.weisro-prev');
    const nextBtn = wrapper.querySelector('.weisro-next');
    const thumbs = Array.from(wrapper.querySelectorAll('.weisro-thumb'));

    // جلب الصور من attribute data-images أو من thumbnails مباشرة
    let images = [];
    if (thumbsWrap && thumbsWrap.dataset && thumbsWrap.dataset.images) {
      images = thumbsWrap.dataset.images.split(',').map(i => i.trim()).filter(Boolean);
    } else {
      images = thumbs.map(t => t.querySelector('img') ? t.querySelector('img').src : null).filter(Boolean);
    }
    if (!images.length) return;

    let current = 0;

    function updateImage(index) {
      if (index < 0) index = images.length - 1;
      if (index >= images.length) index = 0;
      current = index;
      if (mainImg) mainImg.src = images[current];

      // تحديث active على الثامبز
      thumbs.forEach(t => t.classList.remove('active'));
      const activeThumb = thumbs.find(t => parseInt(t.dataset.index, 10) === current);
      if (activeThumb) activeThumb.classList.add('active');
    }

    // أحداث الأزرار
    if (prevBtn) prevBtn.addEventListener('click', () => updateImage(current - 1));
    if (nextBtn) nextBtn.addEventListener('click', () => updateImage(current + 1));

    // أحداث اختيار الثمب
    thumbs.forEach(t => {
      t.addEventListener('click', function () {
        const idx = parseInt(this.dataset.index, 10);
        if (!isNaN(idx)) updateImage(idx);
      });
    });

    // دعم الكيبورد عند فوكس داخل العنصر (اختياري)
    wrapper.addEventListener('keydown', (e) => {
      if (e.key === 'ArrowLeft') updateImage(current - 1);
      if (e.key === 'ArrowRight') updateImage(current + 1);
    });

    // تهيئة أول صورة
    updateImage(0);
  });

});
