<?php
if (!defined('ABSPATH')) exit;

/**
 * Register Meta Box
 */
add_action('add_meta_boxes', function () {
    add_meta_box(
        'vmdp_meta',
        __('تفاصيل المشروع', 'view-mobile-developer-project-weisro'),
        'vmdp_meta_cb',
        'vmdp_project',
        'normal',
        'high'
    );
});

/**
 * Meta Box Fields
 */
function vmdp_meta_cb($post)
{
    $subtitle    = get_post_meta($post->ID, 'vmdp_subtitle', true);
    $description = get_post_meta($post->ID, 'vmdp_description', true);
    $images      = get_post_meta($post->ID, 'vmdp_images', true);
    $tech        = get_post_meta($post->ID, 'vmdp_tech', true);
    $link        = get_post_meta($post->ID, 'vmdp_link', true);

    // تجهيز الصور
    $images_array = [];
    if (!empty($images)) {
        $images_array = array_filter(array_map('trim', explode(',', $images)));
    }
    ?>

    <label><strong><?php _e('النوع (العنوان الفرعي):', 'view-mobile-developer-project-weisro'); ?></strong></label>
    <input type="text" name="vmdp_subtitle" value="<?php echo esc_attr($subtitle); ?>" style="width:100%">

    <br><br>

    <label><strong><?php _e('وصف التطبيق:', 'view-mobile-developer-project-weisro'); ?></strong></label>
    <textarea name="vmdp_description" style="width:100%" rows="4"><?php echo esc_textarea($description); ?></textarea>

    <br><br>

    <label><strong><?php _e('صور التطبيق:', 'view-mobile-developer-project-weisro'); ?></strong></label>
    <div>

        <!-- زر الرفع الصحيح -->
        <button type="button" class="button button-primary weisro-upload-images">
            <?php _e('اختر صور التطبيق', 'view-mobile-developer-project-weisro'); ?>
        </button>

        <!-- الحقل الذي يقرأه admin.js -->
        <input type="hidden" name="vmdp_images" class="weisro-images-field" value="<?php echo esc_attr($images); ?>">

        <!-- المعاينة التي يرسمها admin.js -->
        <div class="weisro-images-preview" style="margin-top:10px;">
            <?php foreach ($images_array as $i => $img): ?>
                <div class="weisro-img-box" data-index="<?php echo $i; ?>" style="position:relative; display:inline-block; margin:5px;">
                    <img src="<?php echo esc_url($img); ?>" 
                         style="width:80px;height:120px;border-radius:6px;object-fit:cover;">
                    <span class="weisro-remove-img" style="
                        position:absolute;
                        top:-6px;
                        right:-6px;
                        width:20px;
                        height:20px;
                        background:#ff4444;
                        color:#fff;
                        border-radius:50%;
                        cursor:pointer;
                        font-size:12px;
                        display:flex;
                        align-items:center;
                        justify-content:center;
                    ">×</span>
                </div>
            <?php endforeach; ?>
        </div>

    </div>

    <br><br>

    <label><strong><?php _e('التقنيات المستخدمة (افصل بينها بفاصلة):', 'view-mobile-developer-project-weisro'); ?></strong></label>
    <textarea name="vmdp_tech" style="width:100%" rows="3"><?php echo esc_textarea($tech); ?></textarea>

    <br><br>

    <label><strong><?php _e('رابط المشروع (URL):', 'view-mobile-developer-project-weisro'); ?></strong></label>
    <input type="url" name="vmdp_link" value="<?php echo esc_attr($link); ?>" style="width:100%">
<?php
}

/**
 * Save Fields
 */
add_action('save_post', function ($post_id) {

    $fields = [
        'vmdp_subtitle',
        'vmdp_description',
        'vmdp_images',
        'vmdp_tech',
        'vmdp_link'
    ];

    foreach ($fields as $field) {

        if (!isset($_POST[$field])) continue;

        // وصف
        if ($field === 'vmdp_description') {
            update_post_meta($post_id, $field, sanitize_textarea_field($_POST[$field]));
            continue;
        }

        // صور
        if ($field === 'vmdp_images') {
            update_post_meta($post_id, $field, sanitize_textarea_field($_POST[$field]));
            continue;
        }

        update_post_meta($post_id, $field, sanitize_text_field($_POST[$field]));
    }
});
