<?php
// template-project-item.php
if (!defined('ABSPATH')) exit;

// project_id ممكن يجي من $args أو من الحلقة (get_the_ID)
$project_id = null;
if (!empty($args) && isset($args['project_id'])) {
    $project_id = intval($args['project_id']);
} elseif (get_the_ID()) {
    $project_id = get_the_ID();
}
if (!$project_id) return;

// الحقول
$title       = get_the_title($project_id);
$subtitle    = get_post_meta($project_id, 'vmdp_subtitle', true);
$description = get_post_meta($project_id, 'vmdp_description', true);
$images_raw  = get_post_meta($project_id, 'vmdp_images', true); // comma-separated URLs
$tech_raw    = get_post_meta($project_id, 'vmdp_tech', true);
$link        = get_post_meta($project_id, 'vmdp_link', true);

// افتراضي: لو ما فيه صور استخدم الصورة الّلي رفعتها (المسار المحلي)
$placeholder = "https://placehold.co/400x800?text=No+Image";

if (empty($images_raw)) {
    $images = array($placeholder);
} else {
    $images = array_filter(array_map('trim', explode(',', $images_raw)));
    if (empty($images)) $images = array($placeholder);
}

// الصورة الرئيسية
$main_image = !empty($images[0]) ? $images[0] : $placeholder;

// التحضير للتقنيات (مصفوفة مفصولة بفواصل)
$techs = [];
if (!empty($tech_raw)) {
    $techs = array_filter(array_map('trim', explode(',', $tech_raw)));
}

// بيانات JS (سلسلة مفصولة بفواصل، نستخدمها في الـ script)
$images_data_attr = esc_attr(implode(',', $images));
?>

<div class="weisro-project-item-wrapper" data-project-id="<?php echo esc_attr($project_id); ?>">

  <div class="weisro-left">
    <h2 class="weisro-main-title"><?php echo esc_html($title); ?></h2>

    <div class="weisro-device-wrap">
      <button class="weisro-nav-btn weisro-prev" aria-label="Previous">‹</button>

      <div class="weisro-device">
        <div class="weisro-screen">
          <img class="weisro-main-image" src="<?php echo esc_url($main_image); ?>" alt="<?php echo esc_attr($title); ?>">
        </div>
      </div>

      <button class="weisro-nav-btn weisro-next" aria-label="Next">›</button>
    </div>

    <div class="weisro-thumbs" data-images="<?php echo $images_data_attr; ?>">
      <?php foreach ($images as $i => $img_url): ?>
        <div class="weisro-thumb <?php echo $i === 0 ? 'active' : ''; ?>" data-index="<?php echo $i; ?>">
          <img src="<?php echo esc_url($img_url); ?>" alt="thumb-<?php echo $i; ?>">
        </div>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="weisro-right">
    <?php if ($subtitle): ?>
      <h3 class="weisro-subtitle"><b style="color:white">نوع التطبيق:</b> <?php echo esc_html($subtitle); ?></h3>
    <?php endif; ?>

    <?php if ($description): ?>
      <div class="weisro-desc"><b style="color:white">وصف التطبيق:</b> <?php echo wp_kses_post(nl2br(esc_html($description))); ?></div>
    <?php endif; ?>

    <?php if (!empty($techs)): ?>
      <b style="color:white">التقنيات المستخدمة:</b><br>
      <div class="weisro-techs">        
        <?php foreach ($techs as $t): ?>
          <span class="weisro-tech-item"><?php echo esc_html($t); ?></span>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>

    <?php if ($link): ?>
      <div style="margin-top:18px;">
        <a class="weisro-open-link" href="<?php echo esc_url($link); ?>" target="_blank" rel="noopener noreferrer">افتح المشروع</a>
      </div>
    <?php endif; ?>
  </div>

</div>
