<?php
/**
 * Plugin Name: View Mobile Developer Project - Weisro
 * Plugin URI:  https://view1sy.com/view-mobile-developer-project-weisro/
 * Description: Display and manage mobile developer project showcase with gallery features.
 * Version: 1.0.0
 * Author: Aamer Barakat
 * Author URI: https://aamerbarakat.com/
 * Text Domain: view-mobile-developer-project-weisro
 * Domain Path: /languages
 * License: GPLv2 or later
 * Requires at least: 6.0
 * Requires PHP: 7.4
 */

if (!defined('ABSPATH')) exit;

/*
|--------------------------------------------------------------------------
| Frontend Assets
|--------------------------------------------------------------------------
*/
add_action('wp_enqueue_scripts', function () {

    wp_enqueue_style(
        'vmdpw-style',
        plugin_dir_url(__FILE__) . 'assets/css/style.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/css/style.css')
    );

    wp_enqueue_script(
        'vmdpw-script',
        plugin_dir_url(__FILE__) . 'assets/js/script.js',
        ['jquery'],
        filemtime(plugin_dir_path(__FILE__) . 'assets/js/script.js'),
        true
    );
});


/*
|--------------------------------------------------------------------------
| Backend (Admin) Assets
|--------------------------------------------------------------------------
*/
add_action('admin_enqueue_scripts', function ($hook) {

    global $post_type;

    if ($post_type !== 'vmdp_project') return;

    wp_enqueue_media();

    wp_enqueue_script(
        'vmdpw-admin',
        plugin_dir_url(__FILE__) . 'assets/js/admin.js',
        ['jquery'],
        filemtime(plugin_dir_path(__FILE__) . 'assets/js/admin.js'),
        true
    );

    wp_enqueue_style(
        'vmdpw-admin-style',
        plugin_dir_url(__FILE__) . 'assets/css/admin.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/css/admin.css')
    );
});


/*
|--------------------------------------------------------------------------
| Includes
|--------------------------------------------------------------------------
*/
require_once __DIR__ . '/inc/cpt.php';
require_once __DIR__ . '/inc/metabox.php';
require_once __DIR__ . '/inc/shortcode.php';
require_once __DIR__ . '/admin/settings-page.php';


/*
|--------------------------------------------------------------------------
| Meta Box: Display Shortcode
|--------------------------------------------------------------------------
*/
add_action('add_meta_boxes', function () {

    add_meta_box(
        'vmdp_project_shortcode',
        'Shortcode المشروع',
        'vmdp_project_shortcode_callback',
        'vmdp_project',
        'side',
        'high'
    );
});

function vmdp_project_shortcode_callback($post)
{
    $id = $post->ID;
    echo '<input type="text" readonly value="[vmdp_project id=&quot;' . $id . '&quot;]" 
           style="width:100%;padding:6px;font-size:14px;">';
    echo '<p>انسخ الشورت كود وضعو ضمن أي صفحة.</p>';
}


/*
|--------------------------------------------------------------------------
| Admin Table Column
|--------------------------------------------------------------------------
*/
add_filter('manage_vmdp_project_posts_columns', function ($columns) {
    $columns['shortcode'] = 'Shortcode';
    return $columns;
});

add_action('manage_vmdp_project_posts_custom_column', function ($column, $post_id) {
    if ($column === 'shortcode') {
        echo '<code>[vmdp_project id="' . $post_id . '"]</code>';
    }
}, 10, 2);

